/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.logging;

import filenet.pe.peorb.FileNet_PERPC.FValue;
import filenet.pe.peorb.FileNet_PERPC.PEConfig;
import filenet.pe.peorb.FileNet_PERPC.PERPCOperations;
import filenet.pe.peorb.FileNet_PERPC.SingleValue;
import filenet.pe.peorb.FileNet_PERPC.TransferResult;
import filenet.pe.peorb.FileNet_PERPC.VWExceptionStruct;
import filenet.pe.peorb.FileNet_PERPC.WorkElement;
import filenet.pe.peorb.FileNet_PERPC.WorkElementUnion;
import filenet.pe.peorb.FileNet_PERPC.WorkObjectId;
import filenet.pe.peorb.FileNet_PERPC.WorkObjectIdOrVWExeption;
import filenet.pe.peorb.FileNet_PERPC.boolOrVWExeption;
import filenet.pe.peorb.FileNet_PERPC.longOrVWExeption;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORBTraceUtils {
    private static HashMap<String, String[]> classSelectorList = new HashMap(32);
    private static HashMap<String, HashMap> classFilterList = new HashMap(16);
    private static HashMap<String, Boolean[]> RPCOptions = null;
    protected static int NUM_RPCS;
    private static long FileLastCheckedTime;
    private static long FILECHECK_INTERVAL;
    private static long FileLastModified;
    private static String FileFilterName;
    private static final String FNTRACEFILTERS_PROPERTIES_FILENAME = "fntracefilters.properties";
    private static String[] ALL_FIELDS;
    private static String[] NO_FIELDS;
    private static final String FIELD_SELECTOR = ".__selector__";
    private static final String FIELD_FILTER = ".__filter__.";
    private static final int FIELD_FILTER_LEN = 12;

    private static StringBuilder newLineAndIndent(StringBuilder b, int indentLevel) {
        b.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            b.append("\t");
        }
        return b;
    }

    private static boolean IsPrimitiveArraysToString(StringBuilder b, Object obj, int len) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof byte[]) {
            byte[] arr = (byte[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof int[]) {
            int[] arr = (int[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof short[]) {
            short[] arr = (short[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof char[]) {
            char[] arr = (char[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof long[]) {
            long[] arr = (long[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof boolean[]) {
            boolean[] arr = (boolean[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof String[]) {
            String[] arr = (String[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof Number[]) {
            Number[] arr = (Number[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        if (obj instanceof Boolean[]) {
            Boolean[] arr = (Boolean[])obj;
            for (int i = 0; i < len; ++i) {
                b.append(arr[i]).append(i == len - 1 ? "" : ",");
            }
            return true;
        }
        return false;
    }

    public static StringBuilder ObjectToString(StringBuilder b, Object obj, int indentLevel) {
        if (obj == null) {
            b.append("null");
            return b;
        }
        Class<?> oCls = obj.getClass();
        if (oCls.isPrimitive() || obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
            b.append(obj);
            return b;
        }
        String className = oCls.getName();
        if (oCls.isArray()) {
            int len = Array.getLength(obj);
            b.append("len=").append(len);
            if (len == 0) {
                return b;
            }
            b.append("[");
            if (ORBTraceUtils.IsPrimitiveArraysToString(b, obj, len)) {
                return b.append("]");
            }
            ++indentLevel;
            for (int i = 0; i < len; ++i) {
                Object iObj = Array.get(obj, i);
                if (!ORBTraceUtils.traceThisObject(iObj)) continue;
                ORBTraceUtils.newLineAndIndent(b, indentLevel).append(i).append(":");
                ORBTraceUtils.ObjectToString(b, iObj, indentLevel);
            }
            ORBTraceUtils.newLineAndIndent(b, indentLevel - 1).append("]");
            return b;
        }
        if (obj instanceof Map) {
            b.append(className).append(" ");
            Map m = (Map)obj;
            int len = m.size();
            b.append(len).append("items");
            if (len == 0) {
                return b;
            }
            ORBTraceUtils.newLineAndIndent(b, indentLevel).append("{");
            ++indentLevel;
            Set s = m.keySet();
            Iterator iter = s.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ORBTraceUtils.newLineAndIndent(b, indentLevel).append(i).append(": key=");
                Object k = iter.next();
                ORBTraceUtils.ObjectToString(b, k, indentLevel);
                Object v = m.get(k);
                ORBTraceUtils.newLineAndIndent(b, indentLevel).append(i).append(": value=");
                ORBTraceUtils.ObjectToString(b, v, indentLevel);
                ++i;
            }
            ORBTraceUtils.newLineAndIndent(b, indentLevel - 1).append("}");
            return b;
        }
        SpecialToStringFunction f = SpecialToStringFunction.Get(className);
        if (f != null && f.getMethod() != null) {
            try {
                b.append(f.getShortClassName()).append(" ");
                return (StringBuilder)f.getMethod().invoke(null, b, obj, indentLevel);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            Method toStringMethod = oCls.getMethod("toString", new Class[0]);
            if (toStringMethod.getDeclaringClass() == oCls) {
                b.append(obj.toString());
                return b;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ORBTraceUtils.ObjectToStringViaFields(b, obj, indentLevel);
    }

    private static boolean IsClassRelated(String keyName, String keyValue) {
        if (!keyName.startsWith("CLASS.")) {
            return false;
        }
        if ((keyName = keyName.substring("CLASS.".length())).endsWith(FIELD_SELECTOR)) {
            keyName = keyName.substring(0, keyName.lastIndexOf(FIELD_SELECTOR));
            String[] flds = null;
            flds = keyValue.equals("*") ? ALL_FIELDS : (keyValue.equals("-") ? NO_FIELDS : keyValue.split(","));
            classSelectorList.put(keyName, flds);
        } else {
            int x = keyName.indexOf(FIELD_FILTER);
            if (x != -1) {
                String clsName = keyName.substring(0, x);
                String filterMemberFieldName = keyName.substring(x + 12);
                if (filterMemberFieldName.length() > 0) {
                    HashMap<String, String> h = classFilterList.get(clsName);
                    if (h == null) {
                        h = new HashMap<String, String>(2);
                    }
                    h.put(filterMemberFieldName, keyValue);
                    classFilterList.put(clsName, h);
                }
            }
        }
        return true;
    }

    private static void GetPERPCMethods() {
        Method[] ms = PERPCOperations.class.getMethods();
        NUM_RPCS = ms == null ? 0 : ms.length;
        RPCOptions = new HashMap(NUM_RPCS);
        for (int i = 0; i < NUM_RPCS; ++i) {
            String rpcName = ms[i].getName();
            RPCOptions.put(rpcName, new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        }
    }

    private static void ResetRPCOptions() {
        for (String s : ORBTraceUtils.GetRPCNamesSet()) {
            RPCOptions.put(s, new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        }
    }

    public static Set<String> GetRPCNamesSet() {
        return RPCOptions.keySet();
    }

    public static boolean traceThisRPC(boolean inParams, String rpcName) {
        int i = inParams ? 0 : 1;
        Boolean[] options = RPCOptions.get(rpcName);
        if (options == null) {
            return true;
        }
        return options[i];
    }

    private static boolean IsRPCRelated(String keyName, String keyValue) {
        if (!keyName.startsWith("RPC.")) {
            return false;
        }
        keyName = keyName.substring("RPC.".length());
        int index = 0;
        if (keyName.equals("in")) {
            index = 0;
        }
        if (keyName.equals("out")) {
            index = 1;
        }
        String[] rpcNames = keyValue.split(",");
        int nRpcs = rpcNames.length;
        boolean bOff = false;
        Set<String> rpcNameList = ORBTraceUtils.GetRPCNamesSet();
        for (int i = 0; i < nRpcs; ++i) {
            char firstChar;
            String rpcName = rpcNames[i].trim();
            if (rpcName.length() == 0 || (firstChar = rpcName.charAt(0)) != '-' && firstChar != '+' && !rpcName.equals("*") && !rpcNameList.contains(rpcName)) continue;
            boolean bl = bOff = firstChar == '-';
            if (firstChar == '-' || firstChar == '+') {
                rpcName = rpcName.substring(1).trim();
            }
            if (rpcName.equals("*")) {
                for (String r : rpcNameList) {
                    ORBTraceUtils.setOneRPCOption(r, index, !bOff);
                }
                continue;
            }
            ORBTraceUtils.setOneRPCOption(rpcName, index, !bOff);
        }
        return true;
    }

    private static void setOneRPCOption(String rpcName, int index, boolean bOpt) {
        Boolean[] options = RPCOptions.get(rpcName);
        if (options != null) {
            options[index] = bOpt;
        }
    }

    public static void SetTraceFilter(String keyName, String keyValue) {
        if (keyName == null || keyName.length() == 0 || keyValue == null || keyValue.trim().length() == 0) {
            return;
        }
        if (ORBTraceUtils.IsClassRelated(keyName = keyName.trim(), keyValue = keyValue.trim())) {
            return;
        }
        ORBTraceUtils.IsRPCRelated(keyName, keyValue);
    }

    private static synchronized void ResetAllOptions() {
        classFilterList.clear();
        classSelectorList.clear();
        ORBTraceUtils.ResetRPCOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void CheckTraceFilters() {
        if (FileFilterName == null) {
            ORBTraceUtils.GetTraceFilterFileName();
        }
        if (FileFilterName == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - FileLastCheckedTime < FILECHECK_INTERVAL) {
            return;
        }
        FileLastCheckedTime = now;
        try {
            File f = new File(FileFilterName);
            if (!f.exists()) {
                ORBTraceUtils.ResetAllOptions();
                FileLastModified = -1L;
                return;
            }
            long lastModified = f.lastModified();
            if (FileLastModified != -1L && lastModified == FileLastModified) {
                return;
            }
            FileLastModified = lastModified;
            HashMap<String, Boolean[]> hashMap = RPCOptions;
            synchronized (hashMap) {
                ORBTraceUtils.ResetAllOptions();
                Properties p = new Properties();
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    p.clear();
                    p.load(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {}
                    }
                }
                Enumeration<Object> keys = p.keys();
                while (keys.hasMoreElements()) {
                    String keyName = (String)keys.nextElement();
                    String keyValue = p.getProperty(keyName);
                    ORBTraceUtils.SetTraceFilter(keyName, keyValue);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private static String GetTraceFilterFileName() {
        if (FileFilterName != null) {
            return FileFilterName;
        }
        try {
            Class<?> cls = Class.forName("filenet.jpe.general.SystemUtils");
            Method m = cls.getMethod("getJPEVIRTUALSERVER_DIR", new Class[0]);
            String parent = (String)m.invoke(null, new Object[0]);
            File parentFile = new File(parent);
            if (parentFile.exists()) {
                File f = new File(parent, FNTRACEFILTERS_PROPERTIES_FILENAME);
                FileFilterName = f.getCanonicalPath();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (FileFilterName == null && (FileFilterName = ORBTraceUtils.getPrivilegedSystemProperty("java.home")) != null) {
            File parentLib = new File(FileFilterName, "lib");
            File f = new File(parentLib, FNTRACEFILTERS_PROPERTIES_FILENAME);
            try {
                FileFilterName = f.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FileFilterName;
    }

    private static boolean traceThisObject(Object obj) {
        int nItems;
        if (obj == null) {
            return false;
        }
        ORBTraceUtils.CheckTraceFilters();
        String clsName = obj.getClass().getName();
        HashMap filters = classFilterList.get(clsName);
        int n = nItems = filters == null ? 0 : filters.size();
        if (nItems == 0) {
            return true;
        }
        try {
            for (String memberName : filters.keySet()) {
                Field f;
                Object o;
                String hvals = (String)filters.get(memberName);
                if (hvals == null || (o = (f = obj.getClass().getField(memberName)).get(obj)) == null) continue;
                String[] values = hvals.split(",");
                int nValues = values.length;
                String fldValue = o.toString();
                for (int i = 0; i < nValues; ++i) {
                    if (!fldValue.equals(values[i])) continue;
                    return true;
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return false;
    }

    private static Field[] getClassSelectorMembers(Class cls) {
        String key = cls.getName();
        String[] value = classSelectorList.get(key);
        if (value == NO_FIELDS) {
            return null;
        }
        if (value == null || value == ALL_FIELDS) {
            return cls.getFields();
        }
        int nItems = value.length;
        Field[] res = new Field[nItems];
        for (int i = 0; i < nItems; ++i) {
            try {
                res[i] = cls.getField(value[i]);
                continue;
            }
            catch (Exception e) {
                res[i] = null;
            }
        }
        return res;
    }

    private static StringBuilder ObjectToStringViaFields(StringBuilder b, Object obj, int indentLevel) {
        int nFields;
        Field[] flds = ORBTraceUtils.getClassSelectorMembers(obj.getClass());
        if (flds == null) {
            return b;
        }
        int n = nFields = flds == null ? 0 : flds.length;
        if (nFields > 0) {
            ORBTraceUtils.newLineAndIndent(b, indentLevel).append("{");
            ++indentLevel;
            for (int i = 0; i < nFields; ++i) {
                Field f = flds[i];
                String fieldName = f.getName();
                if (fieldName.equals("serialVersionUID")) continue;
                ORBTraceUtils.newLineAndIndent(b, indentLevel).append(f.getName());
                try {
                    Object o = f.get(obj);
                    b.append("=");
                    ORBTraceUtils.ObjectToString(b, o, indentLevel);
                    continue;
                }
                catch (Throwable t) {
                    b.append(":Error accessing obj").append(t.getMessage());
                }
            }
            ORBTraceUtils.newLineAndIndent(b, indentLevel - 1).append("}");
        }
        return b;
    }

    static {
        FileLastCheckedTime = System.currentTimeMillis() - 60000L;
        FILECHECK_INTERVAL = 60000L;
        FileLastModified = -1L;
        FileFilterName = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ORBTraceUtils.GetPERPCMethods();
                ORBTraceUtils.CheckTraceFilters();
                return null;
            }
        });
        ALL_FIELDS = new String[]{"*"};
        NO_FIELDS = new String[]{"-"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SpecialToStringFunction {
        OrbWorkObjectIdToStringMethod(WorkObjectId.class.getName(), "OrbWorkObjectIdToString"),
        OrbWorkElementToStringMethod(WorkElement.class.getName(), "OrbWorkElementToString"),
        OrbFValueToStringMethod(FValue.class.getName(), "OrbFValueToString"),
        OrbSingleValueToStringMethod(SingleValue.class.getName(), "OrbSingleValueToString"),
        OrbVWExceptionStructToStringMethod(VWExceptionStruct.class.getName(), "OrbVWExceptionStructToString"),
        OrbboolOrVWExceptionToStringMethod(boolOrVWExeption.class.getName(), "OrbboolOrVWExceptionToString"),
        OrblongOrVWExceptionToStringMethod(longOrVWExeption.class.getName(), "OrblongOrVWExceptionToString"),
        OrbPEConfigToStringToStringMethod(PEConfig.class.getName(), "OrbPEConfigToString"),
        OrbTransferResultToStringMethod(TransferResult.class.getName(), "OrbTransferResultToString"),
        OrbWorkElementUnionToStringMethod(WorkElementUnion.class.getName(), "OrbWorkElementUnionToString"),
        OrbWorkObjectIdOrVWExceptionToStringMethod(WorkObjectIdOrVWExeption.class.getName(), "OrbWorkObjectIdOrVWExceptionToString");

        private String className = null;
        private String shortClassName = null;
        private Method method = null;
        private static final char[] GUIDStringDigits;

        private SpecialToStringFunction(String className, String methodName) {
            this.className = className;
            int i = className.lastIndexOf(46);
            this.shortClassName = i != -1 ? '(' + className.substring(i + 1) + ')' : '(' + className + ')';
            try {
                this.method = ((Object)((Object)this)).getClass().getMethod(methodName, StringBuilder.class, Object.class, Integer.TYPE);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }

        public String getShortClassName() {
            return this.shortClassName;
        }

        public Method getMethod() {
            return this.method;
        }

        public static SpecialToStringFunction Get(String className) {
            for (SpecialToStringFunction f : SpecialToStringFunction.values()) {
                if (f.className == null || !f.className.equals(className)) continue;
                return f;
            }
            return null;
        }

        public static StringBuilder OrbWorkObjectIdToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            WorkObjectId wobId = (WorkObjectId)obj;
            b.append(wobId.queueId).append(",").append(wobId.uniqueID).append(",");
            byte[] bArr = wobId.wobNumber;
            int len = bArr == null ? 0 : bArr.length;
            for (int i = 0; i < len; ++i) {
                byte bt = bArr[i];
                b.append(GUIDStringDigits[0xF & bt >> 4]);
                b.append(GUIDStringDigits[0xF & bt]);
            }
            return b;
        }

        public static StringBuilder OrbWorkElementToString(StringBuilder b, Object obj, int indentLevel) {
            int nFields;
            if (obj == null) {
                return b;
            }
            WorkElement woe = (WorkElement)obj;
            int n = nFields = woe.fields == null ? 0 : woe.fields.length;
            if (nFields == 0 && woe.wobId.queueId == -999) {
                return b.append("EMPTY");
            }
            ORBTraceUtils.ObjectToStringViaFields(b, obj, indentLevel);
            return b;
        }

        public static StringBuilder OrbFValueToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            FValue fv = (FValue)obj;
            switch (fv.discriminator().value()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    return SpecialToStringFunction.OrbSingleValueToString(b, fv.v(), indentLevel);
                }
            }
            return ORBTraceUtils.ObjectToString(b, fv.av(), indentLevel);
        }

        public static StringBuilder OrbSingleValueToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            SingleValue sv = (SingleValue)obj;
            switch (sv.discriminator().value()) {
                case 0: {
                    return b.append("NOTHING");
                }
                case 4: {
                    return b.append(sv.f());
                }
                case 1: {
                    return b.append(sv.t());
                }
                case 2: {
                    return b.append(sv.s());
                }
                case 10: {
                    return b.append(sv.ns());
                }
                case 3: {
                    return b.append(sv.b());
                }
                case 5: {
                    return b.append(sv.d());
                }
                case 6: {
                    return b.append(sv.a());
                }
                case 7: {
                    return b.append(sv.p());
                }
                case 8: {
                    return ORBTraceUtils.ObjectToString(b, sv.ps(), indentLevel);
                }
                case 9: {
                    return b.append(sv.x());
                }
                case 11: {
                    return b.append(sv.w());
                }
                case 13: {
                    return b.append(sv.nsa());
                }
            }
            return b;
        }

        public static StringBuilder OrbVWExceptionStructToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            VWExceptionStruct o = (VWExceptionStruct)obj;
            b.append(o.errorTuple).append(",").append(o.errorTxt);
            return b;
        }

        public static StringBuilder OrbboolOrVWExceptionToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            boolOrVWExeption o = (boolOrVWExeption)obj;
            if (o.discriminator().value() == 0) {
                return b.append(o.b());
            }
            return SpecialToStringFunction.OrbVWExceptionStructToString(b, o.err(), indentLevel);
        }

        public static StringBuilder OrblongOrVWExceptionToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            longOrVWExeption o = (longOrVWExeption)obj;
            if (o.discriminator().value() == 0) {
                return b.append(o.value());
            }
            return SpecialToStringFunction.OrbVWExceptionStructToString(b, o.err(), indentLevel);
        }

        public static StringBuilder OrbPEConfigToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            PEConfig o = (PEConfig)obj;
            switch (o.discriminator()) {
                case 0: {
                    return ORBTraceUtils.ObjectToString(b, o.n(), indentLevel);
                }
                case 1: {
                    return ORBTraceUtils.ObjectToString(b, o.c(), indentLevel);
                }
                case 2: {
                    return ORBTraceUtils.ObjectToString(b, o.u(), indentLevel);
                }
            }
            return b;
        }

        public static StringBuilder OrbTransferResultToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            TransferResult o = (TransferResult)obj;
            switch (o.discriminator()) {
                case 0: {
                    return ORBTraceUtils.ObjectToString(b, o.errors(), indentLevel);
                }
                case 1: {
                    return b.append(o.version());
                }
            }
            return b;
        }

        public static StringBuilder OrbWorkElementUnionToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            WorkElementUnion o = (WorkElementUnion)obj;
            switch (o.discriminator().value()) {
                case 2: {
                    return b.append(o.empty());
                }
                case 1: {
                    return SpecialToStringFunction.OrbVWExceptionStructToString(b, o.err(), indentLevel);
                }
                case 0: {
                    return ORBTraceUtils.ObjectToString(b, o.we(), indentLevel);
                }
            }
            return b;
        }

        public static StringBuilder OrbWorkObjectIdOrVWExceptionToString(StringBuilder b, Object obj, int indentLevel) {
            if (obj == null) {
                return b;
            }
            WorkObjectIdOrVWExeption o = (WorkObjectIdOrVWExeption)obj;
            switch (o.discriminator().value()) {
                case 2: {
                    return b.append(o.empty());
                }
                case 1: {
                    return SpecialToStringFunction.OrbVWExceptionStructToString(b, o.err(), indentLevel);
                }
                case 0: {
                    return SpecialToStringFunction.OrbWorkObjectIdToString(b, o.wobid(), indentLevel);
                }
            }
            return b;
        }

        static {
            GUIDStringDigits = "0123456789ABCDEF".toCharArray();
        }
    }
}

